<?
$data = json_decode(file_get_contents('php://input'), true);

$color = "000000";
$impresora = $data['nombre_impresora'];
$dominio_impresora = $data['dominio_impresora'];
$papel_impresora = $data['papel_impresora'];

$papel_80 = true;
$valor_papel = 0;
$valor_acotar = 0;
$fuente_grande = 30;
$fuente_chica = 24;
if ($papel_impresora == "58") {
	$papel_80 = false;
	$valor_papel = 170;
	$valor_acotar = 5;
	$fuente_grande = 24;
	$fuente_chica = 18;
}

$desplazamiento_x = $data['desplazamiento_x'];
$desplazamiento_y = $data['desplazamiento_y'];


$error = false;
$mensaje = "";

if ($data['codigo'] == 'jfkdhjk3347983rehjkfnbmdbnbewkrhkj39849845789399ujfdhgjkwio43987') {

	$handle = printer_open($impresora);

	if ($handle != "") {

		$comprobante = $data['comprobante'];


		printer_set_option($handle, PRINTER_TEXT_COLOR, $color);
		$pen = printer_create_pen(PRINTER_PEN_SOLID, 6 * $escala, $color);
		printer_select_font($handle, $font);
		$etiquetas = $comprobante;
		foreach ($etiquetas as $etiqueta) {

			$x = 5;
			$salto = 35;

			$resultado = printer_start_doc($handle, "Impresion Ticket");
			if ($resultado == 1) {

				$resultado = printer_start_page($handle);
				if ($resultado == 1) {

					fuente(30);
					$y = 0;
					parrafo(0, $y, utf8_decode($etiqueta['detalle']));

					$y = 80;
					logo(0, $y);

					if ($etiqueta['codigo_barras'] != '') {
						$y = 155;
						fuente(24);
						texto(0, $y, "Cod: " . $etiqueta['codigo_barras']);
					}

					$y = 155;
					fuente(24);
					texto(450 - $valor_papel, $y, $etiqueta['medida']);

					if ($papel_80) {
						$y = 40;
						fuente(120);
						texto(alineacionDecimal(($etiqueta['precio']), 8, 110, false), $y, "$ " . number_format($etiqueta['precio'], 0, ".", ""));
					} else {
						$y = 70;
						fuente(70);
						texto(alineacionDecimal(($etiqueta['precio']), 8, 60, false), $y, "$ " . number_format($etiqueta['precio'], 0, ".", ""));
					}

					$y = 180;
					linea($x, $y);
				} else {
					$error = true;
					$mensaje = "No se pudo abrir la pagina de impresion";
				}
				$resultado = printer_end_page($handle);
				if ($resultado != 1) {
					$error = true;
					$mensaje = "No se pudo cerrar la pagina de impresion";
				}
			} else {
				$error = true;
				$mensaje = "No se pudo abrir el documento de impresion";
			}
			printer_delete_font($font);
			printer_delete_pen($pen);
			$resultado = printer_end_doc($handle);
			if ($resultado != 1) {
				$error = true;
				$mensaje = "No se pudo cerrar el documento de impresion";
			}
		}
		printer_close($handle);
	}
}

function fuente($nro)
{

	global $handle;

	$font = printer_create_font("Arial", $nro, ($nro / 3), 100, false, false, false, 0);
	printer_select_font($handle, $font);
}

function logo($x, &$y)
{

	global $handle;
	global $desplazamiento_x;
	global $papel_80;

	if ($papel_80) {
		printer_draw_bmp($handle, "logo.bmp", $x + $desplazamiento_x, $y, 200, 70);
	} else {
		printer_draw_bmp($handle, "logo.bmp", $x + $desplazamiento_x, $y, 150, 55);
	}
}


function texto($x, &$y, $texto, $enter = true)
{

	global $handle;
	global $desplazamiento_x;
	global $salto;

	printer_draw_text($handle, $texto, $x + $desplazamiento_x, $y);
	if ($enter) {
		$y = $y + $salto;
	}
}


function linea($x, &$y)
{

	global $handle;
	global $desplazamiento_x;
	global $salto;

	printer_draw_line($handle, $x + $desplazamiento_x, $y, $x + $desplazamiento_x + 500, $y);
	$y = $y + $salto;
}

function parrafo($x, &$y, $texto)
{

	global $handle;
	global $desplazamiento_x;
	global $salto;

	$impresion = "";
	$palabras = explode(" ", $texto);
	foreach ($palabras as $palabra) {
		$tamanio = strlen($impresion) + strlen($palabra) + 1;
		if ($tamanio < 40) {
			$impresion .= $palabra . ' ';
		} else {
			printer_draw_text($handle, $impresion, $x + $desplazamiento_x, $y);
			$y = $y + $salto;
			$impresion = $palabra . ' ';
		}
	}
	if ($impresion != "") {
		printer_draw_text($handle, $impresion, $x + $desplazamiento_x, $y);
		$y = $y + $salto;
	}
}


function alineacionDecimal($numero, $entero, $posicion, $negativo = false)
{
	$longitud = strlen(strval(intval($numero)));
	$valor = 30;
	if ($negativo) {
		$longitud++;
		$valor = 13;
	}

	if ($longitud == "1" && $numero < 0) {
		$longitud = 2;
	}

	$retorno = $posicion + (($entero - $longitud) * $valor);

	if ($numero < 0) {
		$retorno = $retorno + 40;
	}
	return $retorno;
}

function floatToStr($valor)
{
	return number_format($valor, 2, '.', '');
}

if ($error) {
	$jsondata['respuesta'] = "error";
	$jsondata['mensaje'] = $mensaje;
} else {
	$jsondata['respuesta'] = "ok";
	$jsondata['mensaje'] = "La impresion se realizo correctamente";
}


if (isset($_SERVER['HTTP_ORIGIN']) && preg_match('/^https?:\/\/([a-zA-Z0-9-]+)\.(pv-gestion\.com\.ar|sao\.mybluehost\.me)$/', $_SERVER['HTTP_ORIGIN'])) {
	header('Content-Type: application/json');
	header('Access-Control-Allow-Headers: Access-Control-Allow-Origin, Content-Type');
	header("Access-Control-Allow-Origin: {$_SERVER['HTTP_ORIGIN']}");
	header('Vary: Origin');
}

echo json_encode($jsondata);
