<?
require_once 'libs/qr/qrlib.php';
require_once 'libs/image-magic/php_image_magician.php';

$data = json_decode(file_get_contents('php://input'), true);

$color = "000000";
$impresora = $data['nombre_impresora'];
$dominio_impresora = $data['dominio_impresora'];
$qr_impresora = $data['qr_impresora'];
$papel_impresora = $data['papel_impresora'];
if ($qr_impresora == "") {
	$qr_impresora = "N";
}
$papel_80 = true;
$valor_papel = 0;
$valor_acotar = 0;
$fuente_grande = 30;
$fuente_chica = 24;
if ($papel_impresora == "58") {
	$papel_80 = false;
	$valor_papel = 120;
	$valor_acotar = 5;
	$fuente_grande = 24;
	$fuente_chica = 18;
}

$desplazamiento_x = $data['desplazamiento_x'];
$desplazamiento_y = $data['desplazamiento_y'];

$x = 5;
$y = 0;
$salto = 35;
$corte = 10000;

$error = false;
$mensaje = "";

if ($data['codigo'] == 'jfkdhjk3347983rehjkfnbmdbnbewkrhkj39849845789399ujfdhgjkwio43987') {

	$handle = printer_open($impresora);

	if ($handle != "") {

		$comprobante = $data['comprobante'];
		$tipo = $comprobante['comprobante'];

		$fiscal = false;
		$anulado = false;
		$codigo = false;
		$cliente = false;
		$proveedor = false;
		$sucursal = false;
		$importe = false;
		$pagos = false;
		$totales = false;
		$saludo = false;
		$observaciones = false;
		$comanda = false;

		if ($comprobante['modo'] == 'F') {
			$fiscal = true;
		}
		if ($comprobante['estado'] == '1') {
			$anulado = true;
		}
		if ($tipo == 'F' || $tipo == 'NC' || $tipo == 'EM' || $tipo == 'P' || $tipo == 'OP' || $tipo == 'L' || $tipo == 'CO') {
			$codigo = true;
			$importe = true;
		}
		if ($tipo == 'F' || $tipo == 'NC' || $tipo == 'EM' || $tipo == 'P' || $tipo == 'OP' || $tipo == 'L') {
			$pagos = true;
		}
		if ($tipo == 'IM') {
			$proveedor = true;
		}
		if ($tipo == 'R') {
			$sucursal = true;
		}
		if ($tipo == 'F' || $tipo == 'NC' || $tipo == 'P' || $tipo == 'OP' || $tipo == 'IM' || $tipo == 'EM' || $tipo == 'L' || $tipo == 'CO') {
			$totales = true;
		}
		if ($tipo == 'F' || $tipo == 'NC' || $tipo == 'EM') {
			$saludo = true;
		}

		if ($tipo == 'IM' || $tipo == 'EM' || $tipo == 'TC' || $tipo == 'R' || $tipo == 'P' || $tipo == 'OP' || $tipo == 'FA' || $tipo == 'OR' || $tipo == 'L' || $tipo == 'CC') {
			$observaciones = true;
		}

		if ($tipo == 'CO' || $tipo == 'CC') {
			$comanda = true;
		}

		printer_set_option($handle, PRINTER_TEXT_COLOR, $color);
		$pen = printer_create_pen(PRINTER_PEN_SOLID, 6 * $escala, $color);
		printer_select_pen($handle, $pen);
		$font = printer_create_font("Arial", 60 * $escala, 30 * $escala, 100, false, false, false, 0);
		printer_select_font($handle, $font);
		$resultado = printer_start_doc($handle, "Impresion Ticket");
		if ($resultado == 1) {
			$resultado = printer_start_page($handle);
			if ($resultado == 1) {
				fuente($fuente_grande);
				if ($papel_80) {
					logo(50, $y);
				} else {
					logo(25, $y);
				}
				$qr = $comprobante['qr'];
				if ($qr && $qr_impresora == "S") {
					QRcode::png($qr, 'libs/temp/qr.png', QR_ECLEVEL_L, 1, 1);
					$magic = new imageLib('libs/temp/qr.png');
					$magic->saveImage('libs/temp/qr.bmp', 1);
				}
				if ($fiscal) {
					texto($x, $y, utf8_decode($comprobante['razonSocialSucursal']));
				}
				texto($x, $y, utf8_decode($comprobante['datos1Sucursal']));
				texto($x, $y, utf8_decode($comprobante['datos2Sucursal']));

				fuente($fuente_grande);

				if ($fiscal) {
					texto($x, $y, "CUIT: " . $comprobante['cuitSucursal'] . "  IIBB: " . $comprobante['iibbSucursal']);
					if ($comprobante['inicioActividadesSucursal']) {
						texto($x, $y, "Inicio de Actividades: " . $comprobante['inicioActividadesSucursal']);
					}
					texto($x, $y, strtoupper($comprobante['ivaSucursal']));
				}
				linea($x, $y);
				texto($x, $y, $comprobante['letra'], false);
				if ($papel_80) {
					texto(295, $y, "Nro: " . $comprobante['numero']);
				} else {
					texto(190, $y, "Nro: " . $comprobante['numero']);
				}
				if ($codigo) {
					fuente($fuente_chica);
					if ($fiscal) {
						$texto_codigo = '(Cod. ' . $comprobante['codigo'] . ')';
						texto($x, $y, $texto_codigo, false);
					}
					fuente($fuente_grande);
				}
				if ($comanda) {
					$texto_codigo = 'Mesa Nro: ' . $comprobante['mesa'];
					texto($x, $y, $texto_codigo, false);
				}
				if ($papel_80) {
					texto(325, $y, "Fecha: " . $comprobante['fecha']);
					texto(390, $y, "Hora: " . $comprobante['hora']);
				} else {
					texto(215, $y, "Fecha: " . $comprobante['fecha']);
					texto(270, $y, "Hora: " . $comprobante['hora']);
				}
				linea($x, $y);
				if ($codigo) {
					if (!$fiscal) {
						$texto_codigo = 'DOCUMENTO NO V�LIDO COMO FACTURA';
						if ($papel_80) {
							fuente(22);
							texto(90, $y, $texto_codigo);
						} else {
							fuente(22);
							texto(5, $y, $texto_codigo);
						}
						fuente($fuente_grande);
						linea($x, $y);
					}
				}

				if ($anulado) {
					if ($papel_80) {
						texto(80, $y, "***** COMPROBANTE ANULADO *****");
					} else {
						texto(5, $y, "** COMPROBANTE ANULADO **");
					}
					linea($x, $y);
				}
				if ($comprobante['razonSocial'] != "") {
					texto($x, $y, utf8_decode($comprobante['razonSocial']));
					texto($x, $y, utf8_decode($comprobante['domicilio']));
					texto($x, $y, $comprobante['tipoDocumento'] . ' ' . $comprobante['numeroDocumento']);
					texto($x, $y, strtoupper($comprobante['responsabilidad']));
				} else {
					if ($proveedor) {
						texto($x, $y, "Proveedor: " . utf8_decode($comprobante['razonSocialProveedor']));
					} else {
						if ($sucursal) {
							texto($x, $y, "Sucursal Origen:", false);
							texto(200, $y, utf8_decode($comprobante['nombreSucursalOrigen']));
							texto($x, $y, "Sucursal Destino:", false);
							texto(200, $y, utf8_decode($comprobante['nombreSucursalDestino']));
						} else {
							texto($x, $y, "A CONSUMIDOR FINAL");
						}
					}
				}

				linea($x, $y);

				$items = $comprobante['items'];
				foreach ($items as $item) {
					if ($importe) {
						texto($x, $y, $item['cantidad'] . " (" . $item['medida'] . ") x " . $item['importe'], false);
						if ($papel_80) {
							texto(250, $y, "[" . floatToStr($item['iva']) . "]");
						} else {
							texto(200, $y, "[" . floatToStr($item['iva']) . "]");
						}
						texto($x, $y, utf8_decode(acotar(strtoupper($item['descripcion']), 30 - $valor_acotar)), false);
						texto(alineacionDecimal(($item['total']), 8, 380 - $valor_papel), $y, number_format($item['total'], 2, ".", ""));
					} else {
						texto($x, $y, $item['cantidad'] . " (" . $item['medida'] . ")");
						texto($x, $y, acotar(strtoupper($item['descripcion']), 40 - $valor_acotar));
					}
				}
				saltoLinea($y);

				$recargos = $comprobante['recargos'];
				foreach ($recargos as $recargo) {
					texto($x, $y, "VARIOS GENERAL", false);
					texto(alineacionDecimal(($recargo['importe']), 8, 380 - $valor_papel), $y, number_format($recargo['importe'], 2, ".", ""));
				}

				$descuentos = $comprobante['descuentos'];
				foreach ($descuentos as $descuento) {
					texto($x, $y, utf8_decode(acotar(strtoupper($descuento['descripcion']), 30 - $valor_acotar)), false);
					texto(alineacionDecimal(($descuento['importe']), 8, 380 - $valor_papel, true), $y, number_format(-$descuento['importe'], 2, ".", ""));
				}

				saltoLinea($y);

				if ($fiscal) {

					if ($comprobante['tipo'] == 'A') {
						texto(150, $y, "Importe Neto", false);
						texto(alineacionDecimal(($comprobante['neto']), 8, 380 - $valor_papel), $y, number_format($comprobante['neto'], 2, ".", ""));
						texto(150, $y, "IVA 10.50 %", false);
						texto(alineacionDecimal(($comprobante['iva_10_5']), 8, 380 - $valor_papel), $y, number_format($comprobante['iva_10_5'], 2, ".", ""));
						texto(150, $y, "IVA 21.00 %", false);
						texto(alineacionDecimal(($comprobante['iva_21']), 8, 380 - $valor_papel), $y, number_format($comprobante['iva_21'], 2, ".", ""));
					}
				}
				if ($totales) {
					fuente($fuente_grande + 6);
					texto(150, $y, "TOTAL", false);
					if ($papel_80) {
						texto(alineacionDecimal(($comprobante['total']), 8, 360 - $valor_papel), $y, number_format($comprobante['total'], 2, ".", ""));
					} else {
						texto(alineacionDecimal(($comprobante['total']), 8, 368 - $valor_papel), $y, number_format($comprobante['total'], 2, ".", ""));
					}
					fuente($fuente_grande);
				}

				linea($x, $y);

				if ($pagos) {
					if ($tipo == "EM") {
						texto($x, $y, "RECIBIMOS:");
						texto($x, $y, " - A Cuenta Corriente", false);
						texto(alineacionDecimal(($comprobante['total']), 8, 380 - $valor_papel), $y, number_format($comprobante['total'], 2, ".", ""));
					} else {
						$texto_pago = "RECIBIMOS:";
						if ($tipo == "P") {
							$texto_pago = "SIMULACI�N PAGOS:";
						}
						texto($x, $y, $texto_pago);
						texto($x, $y, " - Efectivo", false);
						texto(alineacionDecimal(($comprobante['pagoCompra']), 8, 380 - $valor_papel), $y, number_format($comprobante['pagoCompra'], 2, ".", ""));
						$pagos = $comprobante['pagos'];
						foreach ($pagos as $pago) {
							if ($pago['tipo'] != 'E') {
								texto($x, $y, utf8_decode(acotar(" - " . $pago['descripcion'] . " - " . $pago['descripcionPlan'], 30 - $valor_acotar)), false);
								texto(alineacionDecimal(($pago['importeTotal']), 8, 380 - $valor_papel), $y, number_format($pago['importeTotal'], 2, ".", ""));
							}
						}
						texto($x, $y, "SU VUELTO:", false);
						texto(alineacionDecimal(($comprobante['vueltoCompra']), 8, 380 - $valor_papel), $y, number_format($comprobante['vueltoCompra'], 2, ".", ""));
					}
					linea($x, $y);
				}

				if ($observaciones) {
					if ($comprobante['observaciones'] != "") {
						parrafo($x, $y, utf8_decode($comprobante['observaciones']));
						linea($x, $y);
					}
				}

				if ($comprobante['garantia'] != "") {
					if ($comprobante['garantia'] == "S") {
						texto($x, $y, "Garant�a: SI");
					} else {
						texto($x, $y, "Garant�a: NO");
					}
					linea($x, $y);
				}

				if ($saludo) {
					if ($papel_80) {
						texto(100, $y, "--- GRACIAS POR TU VISITA ---");
					} else {
						texto(5, $y, "-- GRACIAS POR TU VISITA --");
					}
				}

				if ($comprobante['leyenda'] != "") {
					linea($x, $y);
					parrafo($x, $y, utf8_decode($comprobante['leyenda']));
					linea($x, $y);
				}

				if ($fiscal) {
					fuente($fuente_chica);
					if ($papel_80) {
						texto(140, $y, "Orientacion al Consumidor");
						texto(80, $y, "Provincia de Buenos Aires 0800-222-9042");
					} else {
						texto(5, $y, "Orientacion al Consumidor");
						texto(5, $y, "Provincia de Buenos Aires 0800-222-9042");
					}

					linea($x, $y);

					fuente(24);
					if ($papel_80) {
						texto($x, $y, "Regimen de Transparencia Fiscal al Consumidor (Ley 27.743)");
					} else {
						texto($x, $y, "Regimen de Transparencia Fiscal");
						texto($x, $y, "al Consumidor (Ley 27.743)");
					}
					texto($x, $y, " - IVA Contenido", false);
					texto(alineacionDecimal(($comprobante['iva']), 8, 380 - $valor_papel), $y, number_format($comprobante['iva'], 2, ".", ""));
					if ($papel_80) {
						texto($x, $y, " - Otros Impuestos Nacionales Indirectos", false);
					} else {
						texto($x, $y, " - Otros Impuestos");
						texto($x, $y, "   Nacionales Indirectos", false);
					}
					texto(alineacionDecimal((0.00), 8, 380 - $valor_papel), $y, number_format(0.00, 2, ".", ""));
					linea($x, $y);

					texto(5, $y, "CAE: " . $comprobante['cae']);
					texto(5, $y, "Vto. CAE: " . $comprobante['fechaCae']);
					if ($qr_impresora == "S") {
						qr($x, $y);
					}
				}
				fuente($fuente_grande);
				if ($anulado) {
					linea($x, $y);
					if ($papel_80) {
						texto(80, $y, "***** COMPROBANTE ANULADO *****");
					} else {
						texto(15, $y, "** COMPROBANTE ANULADO **");
					}
					linea($x, $y);
				}
				saltoLinea($y);
				linea($x, $y);
			} else {
				$error = true;
				$mensaje = "No se pudo abrir la pagina de impresion";
			}
			$resultado = printer_end_page($handle);
			if ($resultado != 1) {
				$error = true;
				$mensaje = "No se pudo cerrar la pagina de impresion";
			}
		} else {
			$error = true;
			$mensaje = "No se pudo abrir el documento de impresion";
		}
		printer_delete_font($font);
		printer_delete_pen($pen);
		$resultado = printer_end_doc($handle);
		if ($resultado != 1) {
			$error = true;
			$mensaje = "No se pudo cerrar el documento de impresion";
		}
		printer_close($handle);
	}
}

function fuente($nro)
{

	global $handle;

	$font = printer_create_font("Arial", $nro, ($nro / 3), 100, false, false, false, 0);
	printer_select_font($handle, $font);
}

function logo($x, &$y)
{

	global $handle;
	global $desplazamiento_x;
	global $papel_80;

	if ($papel_80) {
		printer_draw_bmp($handle, "logo.bmp", $x + $desplazamiento_x, $y, 400, 140);
	} else {
		printer_draw_bmp($handle, "logo.bmp", $x + $desplazamiento_x, $y, 320, 120);
	}
	$y = $y + 170;
}

function qr($x, &$y)
{

	global $handle;

	printer_draw_bmp($handle, "libs/temp/qr.bmp", 0, $y, 250, 250);
	$y = $y + 280;

	unlink('libs/temp/qr.png');
	unlink('libs/temp/qr.bmp');
}


function texto($x, &$y, $texto, $enter = true)
{

	global $handle;
	global $desplazamiento_x;
	global $salto;
	global $corte;

	printer_draw_text($handle, $texto, $x + $desplazamiento_x, $y);
	if ($enter) {
		$y = $y + $salto;
	}

	if ($y > $corte) {
		printer_end_doc($handle);
		printer_start_doc($handle, "Impresion Ticket");
		$y = 0;
	}
}

function parrafo($x, &$y, $texto)
{

	global $handle;
	global $desplazamiento_x;
	global $salto;
	global $papel_80;

	$tam_corte = 45;
	if ($papel_80) {
		$tam_corte = 50;
	}

	$impresion = "";
	$palabras = explode(" ", $texto);
	foreach ($palabras as $palabra) {
		$tamanio = strlen($impresion) + strlen($palabra) + 1;
		if ($tamanio < $tam_corte) {
			$impresion .= $palabra . ' ';
		} else {
			printer_draw_text($handle, $impresion, $x + $desplazamiento_x, $y);
			$y = $y + $salto;
			$impresion = $palabra . ' ';
		}
	}
	if ($impresion != "") {
		printer_draw_text($handle, $impresion, $x + $desplazamiento_x, $y);
		$y = $y + $salto;
	}
}

function saltoLinea(&$y)
{

	global $salto;

	$y = $y + $salto;
}

function linea($x, &$y)
{

	global $handle;
	global $desplazamiento_x;
	global $salto;
	global $papel_80;

	if ($papel_80) {
		printer_draw_line($handle, $x + $desplazamiento_x, $y + 10, $x + $desplazamiento_x + 500, $y + 10);
	} else {
		printer_draw_line($handle, $x + $desplazamiento_x, $y + 10, $x + $desplazamiento_x + 360, $y + 10);
	}
	$y = $y + $salto;
}

function acotar($valor, $numero)
{
	return substr($valor, 0, $numero);
}

function alineacionDecimal($numero, $entero, $posicion, $negativo = false)
{
	if ($papel_80) {
		$longitud = strlen(strval(intval($numero)));
		$valor = 12;
		if ($negativo) {
			$longitud++;
			$valor = 13;
		}

		if ($longitud == "1" && $numero < 0) {
			$longitud = 2;
		}

		$retorno = $posicion + (($entero - $longitud) * $valor);

		if ($numero < 0) {
			$retorno = $retorno + 12;
		}
	} else {
		$longitud = strlen(strval(intval($numero)));
		$valor = 10;
		if ($negativo) {
			$longitud++;
			$valor = 11;
		}

		if ($longitud == "1" && $numero < 0) {
			$longitud = 2;
		}

		$retorno = $posicion + (($entero - $longitud) * $valor);

		if ($numero < 0) {
			$retorno = $retorno + 10;
		}
	}
	return $retorno;
}

function floatToStr($valor)
{
	return number_format($valor, 2, '.', '');
}

if ($error) {
	$jsondata['respuesta'] = "error";
	$jsondata['mensaje'] = $mensaje;
} else {
	$jsondata['respuesta'] = "ok";
	$jsondata['mensaje'] = "La impresion se realizo correctamente";
}

if (isset($_SERVER['HTTP_ORIGIN']) && preg_match('/^https?:\/\/([a-zA-Z0-9-]+)\.(pv-gestion\.com\.ar|sao\.mybluehost\.me)$/', $_SERVER['HTTP_ORIGIN'])) {
	header('Content-Type: application/json');
	header('Access-Control-Allow-Headers: Access-Control-Allow-Origin, Content-Type');
	header("Access-Control-Allow-Origin: {$_SERVER['HTTP_ORIGIN']}");
	header('Vary: Origin');
}

echo json_encode($jsondata);
