<?
$data = json_decode(file_get_contents('php://input'), true);

$color = "000000";
$impresora = $data['nombre_impresora'];
$dominio_impresora = $data['dominio_impresora'];
$papel_impresora = $data['papel_impresora'];

$papel_80 = true;
$valor_papel = 0;
$valor_acotar = 0;
$fuente_grande = 30;
$fuente_chica = 24;
if ($papel_impresora == "58") {
	$papel_80 = false;
	$valor_papel = 120;
	$valor_acotar = 5;
	$fuente_grande = 24;
	$fuente_chica = 18;
}

$desplazamiento_x = $data['desplazamiento_x'];
$desplazamiento_y = $data['desplazamiento_y'];
$x = 5;
$y = 0;
$salto = 35;
$corte = 10000;

$error = false;
$mensaje = "";

if ($data['codigo'] == 'jfkdhjk3347983rehjkfnbmdbnbewkrhkj39849845789399ujfdhgjkwio43987') {

	$handle = printer_open($impresora);

	if ($handle != "") {

		$comprobante = $data['comprobante'];

		printer_set_option($handle, PRINTER_TEXT_COLOR, $color);
		$pen = printer_create_pen(PRINTER_PEN_SOLID, 6 * $escala, $color);
		printer_select_pen($handle, $pen);
		$font = printer_create_font("Arial", 60 * $escala, 30 * $escala, 100, false, false, false, 0);
		printer_select_font($handle, $font);
		$resultado = printer_start_doc($handle, "Impresion Ticket");
		if ($resultado == 1) {
			$resultado = printer_start_page($handle);
			if ($resultado == 1) {
				fuente($fuente_grande);
				if ($papel_80) {
					logo(50, $y);
				} else {
					logo(25, $y);
				}
				texto($x, $y, utf8_decode($comprobante['razonSocialSucursal']));
				texto($x, $y, utf8_decode($comprobante['datos1Sucursal']));
				texto($x, $y, utf8_decode($comprobante['datos2Sucursal']));
				linea($x, $y);
				texto($x, $y, $comprobante['tipo'], false);

				if ($papel_80) {
					texto(362, $y, "Nro: " . $comprobante['numero']);
					texto(325, $y, "Fecha: " . $comprobante['fecha']);
					texto(390, $y, "Hora: " . $comprobante['hora']);
				} else {
					texto(250, $y, "Nro: " . $comprobante['numero']);
					texto(215, $y, "Fecha: " . $comprobante['fecha']);
					texto(270, $y, "Hora: " . $comprobante['hora']);
				}
				linea($x, $y);
				texto($x, $y, "Sucursal:", false);
				texto(130, $y, utf8_decode($comprobante['nombreSucursal']));
				texto($x, $y, "Puesto:", false);
				texto(130, $y, utf8_decode($comprobante['nombrePuesto']));
				texto($x, $y, "Usuario:", false);
				texto(130, $y, utf8_decode($comprobante['nombreUsuario']));
				linea($x, $y);

				texto($x, $y, "INGRESO MANUAL", false);
				texto(alineacionDecimal(($comprobante['ingresoManual']), 8, 380 - $valor_papel), $y, number_format($comprobante['ingresoManual'], 2, ".", ""));
				texto($x, $y, "INGRESO FISCAL", false);
				texto(alineacionDecimal(($comprobante['ingresoFiscal']), 8, 380 - $valor_papel), $y, number_format($comprobante['ingresoFiscal'], 2, ".", ""));

				$items = $comprobante['items'];
				foreach ($items as $item) {
					texto($x, $y, utf8_decode(acotar(strtoupper($item['detalle'] . ' - ' . $item['observacion']), 30 - $valor_acotar)), false);
					if ($item['tipo'] == "E") {
						texto(alineacionDecimal(($item['total']), 8, 380 - $valor_papel, true), $y, number_format(-$item['total'], 2, ".", ""));
					} else {
						texto(alineacionDecimal(($item['total']), 8, 380 - $valor_papel), $y, number_format($item['total'], 2, ".", ""));
					}
				}
				saltoLinea($y);

				texto(150, $y, "Ingresos", false);
				texto(alineacionDecimal(($comprobante['ingresos']), 8, 380 - $valor_papel), $y, number_format($comprobante['ingresos'], 2, ".", ""));
				texto(150, $y, "Egresos", false);
				texto(alineacionDecimal(($comprobante['egresos']), 8, 380 - $valor_papel), $y, number_format($comprobante['egresos'], 2, ".", ""));
				texto(150, $y, "Total", false);
				texto(alineacionDecimal(($comprobante['total']), 8, 380 - $valor_papel), $y, number_format($comprobante['total'], 2, ".", ""));
				texto(150, $y, "Caja Efectivo", false);
				texto(alineacionDecimal(($comprobante['cajaEfectivo']), 8, 380 - $valor_papel), $y, number_format($comprobante['cajaEfectivo'], 2, ".", ""));
				texto(150, $y, "Caja Cupones", false);
				texto(alineacionDecimal(($comprobante['cajaCupones']), 8, 380 - $valor_papel), $y, number_format($comprobante['cajaCupones'], 2, ".", ""));
				texto(150, $y, "DIFERENCIA", false);
				if ($comprobante['diferencia'] < 0) {
					texto(alineacionDecimal(($comprobante['diferencia']), 8, 380 - $valor_papel, true), $y, number_format($comprobante['diferencia'], 2, ".", ""));
				} else {
					texto(alineacionDecimal(($comprobante['diferencia']), 8, 380 - $valor_papel), $y, number_format($comprobante['diferencia'], 2, ".", ""));
				}

				saltoLinea($y);
				linea($x, $y);
			} else {
				$error = true;
				$mensaje = "No se pudo abrir la pagina de impresion";
			}
			$resultado = printer_end_page($handle);
			if ($resultado != 1) {
				$error = true;
				$mensaje = "No se pudo cerrar la pagina de impresion";
			}
		} else {
			$error = true;
			$mensaje = "No se pudo abrir el documento de impresion";
		}
		printer_delete_font($font);
		printer_delete_pen($pen);
		$resultado = printer_end_doc($handle);
		if ($resultado != 1) {
			$error = true;
			$mensaje = "No se pudo cerrar el documento de impresion";
		}
		printer_close($handle);
	}
}

function fuente($nro)
{

	global $handle;

	$font = printer_create_font("Arial", $nro, ($nro / 3), 100, false, false, false, 0);
	printer_select_font($handle, $font);
}

function logo($x, &$y)
{

	global $handle;
	global $desplazamiento_x;
	global $papel_80;

	if ($papel_80) {
		printer_draw_bmp($handle, "logo.bmp", $x + $desplazamiento_x, $y, 400, 140);
	} else {
		printer_draw_bmp($handle, "logo.bmp", $x + $desplazamiento_x, $y, 320, 120);
	}
	$y = $y + 170;
}


function texto($x, &$y, $texto, $enter = true)
{

	global $handle;
	global $desplazamiento_x;
	global $salto;
	global $corte;

	printer_draw_text($handle, $texto, $x + $desplazamiento_x, $y);
	if ($enter) {
		$y = $y + $salto;
	}

	if ($y > $corte) {
		printer_end_doc($handle);
		printer_start_doc($handle, "Impresion Ticket");
		$y = 0;
	}
}

function parrafo($x, &$y, $texto)
{

	global $handle;
	global $desplazamiento_x;
	global $salto;
	global $papel_80;

	$tam_corte = 45;
	if ($papel_80) {
		$tam_corte = 50;
	}

	$impresion = "";
	$palabras = explode(" ", $texto);
	foreach ($palabras as $palabra) {
		$tamanio = strlen($impresion) + strlen($palabra) + 1;
		if ($tamanio < $tam_corte) {
			$impresion .= $palabra . ' ';
		} else {
			printer_draw_text($handle, $impresion, $x + $desplazamiento_x, $y);
			$y = $y + $salto;
			$impresion = $palabra . ' ';
		}
	}
	if ($impresion != "") {
		printer_draw_text($handle, $impresion, $x + $desplazamiento_x, $y);
		$y = $y + $salto;
	}
}

function saltoLinea(&$y)
{

	global $salto;

	$y = $y + $salto;
}

function linea($x, &$y)
{

	global $handle;
	global $desplazamiento_x;
	global $salto;
	global $papel_80;

	if ($papel_80) {
		printer_draw_line($handle, $x + $desplazamiento_x, $y + 10, $x + $desplazamiento_x + 500, $y + 10);
	} else {
		printer_draw_line($handle, $x + $desplazamiento_x, $y + 10, $x + $desplazamiento_x + 360, $y + 10);
	}
	$y = $y + $salto;
}

function acotar($valor, $numero)
{
	return substr($valor, 0, $numero);
}

function alineacionDecimal($numero, $entero, $posicion, $negativo = false)
{
	if ($papel_80) {
		$longitud = strlen(strval(intval($numero)));
		$valor = 12;
		if ($negativo) {
			$longitud++;
			$valor = 13;
		}

		if ($longitud == "1" && $numero < 0) {
			$longitud = 2;
		}

		$retorno = $posicion + (($entero - $longitud) * $valor);

		if ($numero < 0) {
			$retorno = $retorno + 12;
		}
	} else {
		$longitud = strlen(strval(intval($numero)));
		$valor = 10;
		if ($negativo) {
			$longitud++;
			$valor = 11;
		}

		if ($longitud == "1" && $numero < 0) {
			$longitud = 2;
		}

		$retorno = $posicion + (($entero - $longitud) * $valor);

		if ($numero < 0) {
			$retorno = $retorno + 10;
		}
	}
	return $retorno;
}

function floatToStr($valor)
{
	return number_format($valor, 2, '.', '');
}

if ($error) {
	$jsondata['respuesta'] = "error";
	$jsondata['mensaje'] = $mensaje;
} else {
	$jsondata['respuesta'] = "ok";
	$jsondata['mensaje'] = "La impresion se realizo correctamente";
}

if (isset($_SERVER['HTTP_ORIGIN']) && preg_match('/^https?:\/\/([a-zA-Z0-9-]+)\.(pv-gestion\.com\.ar|sao\.mybluehost\.me)$/', $_SERVER['HTTP_ORIGIN'])) {
	header('Content-Type: application/json');
	header('Access-Control-Allow-Headers: Access-Control-Allow-Origin, Content-Type');
	header("Access-Control-Allow-Origin: {$_SERVER['HTTP_ORIGIN']}");
	header('Vary: Origin');
}

echo json_encode($jsondata);
